﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class MainForm
    Inherits System.Windows.Forms.Form

    ' 用于指定加载数据时 DisplayArrayData
    ' 方法应使用哪个列表框。
    Private Enum WhichListBox
        BoxOne
        BoxTwo
    End Enum

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' 设置应用程序窗体的标题。
        Me.optValues.Checked = True
        Me.optName.Checked = True
    End Sub

    Private Sub cmdBinarySearch_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdBinarySearch.Click
        Dim message As String
        Dim position As Integer
        Dim valueToFind As Integer
        Dim stringToFind As String = ""

        If Me.optValues.Checked OrElse Me.optId.Checked Then
            ' 查找整数搜索值。
            Try
                valueToFind = CInt(Me.txtBSearchFor.Text)
            Catch ex As Exception
                MessageBox.Show("Please enter an integer to search for.", "Binary Search", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                Me.txtBSearchFor.Select()
                Exit Sub
            End Try
        Else
            ' 确保存在一个值以使用搜索条件。
            If Me.txtBSearchFor.Text.Length = 0 Then
                MessageBox.Show("Please enter a value to search for", "Binary Search", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                Me.txtBSearchFor.Select()
                Exit Sub
            End If
            stringToFind = Me.txtBSearchFor.Text
        End If

        Me.lstAfter.Items.Clear()


        If Me.optValues.Checked Then
            Dim valueArray() As Integer = MakeValueArray()
            DisplayArrayData(valueArray)
            ' 对数组进行排序，否则 BinarySearch 方法无法工作。
            Array.Sort(valueArray)

            ' 显示经过排序后的数据。
            DisplayArrayData(valueArray)

            ' 执行搜索
            position = Array.BinarySearch(valueArray, valueToFind)

            If position >= 0 Then
                message = String.Format("The value {0} was found in the array at position {1}.", valueToFind, position.ToString())
            Else
                ' 如果未找到该项，则返回负数。
                ' 这是该项应在位置的
                ' 按位补数（如果存在该项）。
                ' 我们使用 Not 运算符将其变为正数。
                Dim intBWC As Integer = (Not position)
                message = String.Format("The value {0} was NOT found in the array. If it did exist it would be at position {1}.", valueToFind, intBWC)
            End If
        Else
            Dim objData() As Customer = MakeObjectArray()
            DisplayArrayData(objData)
            ' 搜索对象数组时，我们需要
            ' 使用可兼容的对象类型。
            ' 在本例中，我们使用 txtBSearchFor 框提供的值作为
            ' 客户名称，并提供一个假的 Id 值。
            ' 对对象进行二进制搜索的关键在于
            ' 该对象必须实现 IComparable。
            Dim c As Customer

            If optId.Checked Then
                Customer.SetCompareKey(Customer.CompareField.Id)
                Array.Sort(objData)
                c = New Customer(valueToFind, "")
            Else
                Customer.SetCompareKey(Customer.CompareField.Name)
                Array.Sort(objData)
                c = New Customer(1, stringToFind)
            End If

            DisplayArrayData(objData)

            position = Array.BinarySearch(objData, c)

            If position >= 0 Then
                message = String.Format("The value {0} was found in the array at position {1}.", stringToFind, position.ToString())
            Else
                Dim intBWC As Integer = (Not position)
                message = String.Format("The value {0} was NOT found in the array. If it did exist it would be at position {1}.", stringToFind, intBWC)
            End If

        End If

        MessageBox.Show(message, "Binary Search Results", MessageBoxButtons.OK, MessageBoxIcon.Information)
    End Sub

    Private Sub cmdCreateDynamic_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdCreateDynamic.Click
        ' 此例程生成一个动态数组，
        '使用 txtLength 中指定的值
        ' 设置存储桶的数目。
        If Me.optValues.Checked Then
            Dim dynamicValueData() As Integer
            ReDim dynamicValueData(CInt(Me.numberElements.Value) - 1)
            Dim i As Integer
            For i = 0 To dynamicValueData.Length - 1
                Try
                    dynamicValueData(i) = CType(InputBox("Enter a number", i.ToString(), "None " & i), Integer)
                Catch
                    dynamicValueData(i) = 0
                End Try
            Next
            DisplayArrayData(dynamicValueData)
        Else
            Dim dynamicObjectData() As Customer
            ReDim dynamicObjectData(CInt(Me.numberElements.Value) - 1)
            Dim i As Integer

            For i = 0 To dynamicObjectData.Length - 1
                dynamicObjectData(i) = New Customer
                dynamicObjectData(i).Id = ((i + 1) * 10)
                dynamicObjectData(i).Name = InputBox("Enter a string", ("Item " & (i + 1)), ("None " & i + 1))
            Next
            DisplayArrayData(dynamicObjectData)
        End If
        lstAfter.Items.Clear()
    End Sub

    Private Sub cmdCreateMatrix_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdCreateMatrix.Click
        ' 此过程使用新的初始化语法创建简单的矩阵数组。
        Dim strMatrix(,) As String = {{"Red", "Green"}, {"Yellow", "Purple"}, {"Blue", "Orange"}}
        Me.DisplayArrayData(strMatrix)
        lstAfter.Items.Clear()
    End Sub

    Private Sub cmdCreateStatic_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdCreateStatic.Click
        ' 此过程使用新的初始化生成静态的字符串数组
        ' 或 Customer 对象数组。
        ' 注意，该数组当然也可以使用 ReDim 语句调整大小。
        If Me.optValues.Checked Then
            Dim valueData() As Integer = MakeValueArray()
            DisplayArrayData(valueData)
        Else
            ' .NET 中的对象可具有参数化的构造函数，
            ' 这里的命令就利用了这一点。这使得我们可在一行代码中
            ' 指定对象的数组。
            Dim objData() As Customer = MakeObjectArray()
            DisplayArrayData(objData)
        End If
        lstAfter.Items.Clear()
    End Sub

    Private Sub cmdReverse_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdReverse.Click
        ' 反转是将数组中的元素按照添加元素时使用的降序重新排列。
        Me.lblDataAfter.Text = "Data After Reverse"
        If Me.optValues.Checked Then
            Dim valueArray() As Integer = MakeValueArray()
            DisplayArrayData(valueArray, WhichListBox.BoxOne)
            Array.Reverse(valueArray)
            DisplayArrayData(valueArray, WhichListBox.BoxTwo)
        Else
            Dim objData() As Customer = MakeObjectArray()
            DisplayArrayData(objData, WhichListBox.BoxOne)
            Array.Reverse(objData)
            DisplayArrayData(objData, WhichListBox.BoxTwo)
        End If

    End Sub

    Private Sub cmdSort_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdSort.Click
        ' 为了使此过程工作，数组中包含的项
        ' 必须支持比较。这由对象通过实现
        ' IComparable 接口完成。
        ' 有关更多信息，请参见下面的 Customer 对象定义。

        Me.lblDataAfter.Text = "Data After Sort"

        If Me.optValues.Checked Then
            Dim valueArray() As Integer = MakeValueArray()
            DisplayArrayData(valueArray, WhichListBox.BoxOne)
            Array.Sort(valueArray)
            DisplayArrayData(valueArray, WhichListBox.BoxTwo)
        Else
            Dim objData() As Customer = MakeObjectArray()
            DisplayArrayData(objData, WhichListBox.BoxOne)
            Array.Sort(objData)
            DisplayArrayData(objData, WhichListBox.BoxTwo)
        End If

    End Sub


    ' 在选项更改时重新开始。
    Private Sub CompareKeyCheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) _
        Handles optId.CheckedChanged, optName.CheckedChanged, optObjects.CheckedChanged, optValues.CheckedChanged

        Dim opt As RadioButton = CType(sender, RadioButton)
        ' 在应用排序或搜索时更改 Customer 对象
        ' 使用的字段。
        If opt.Name = "optId" Then
            ' SetCompareKey 是可影响此 AppDomain 中 Customer 类型的
            ' 所有实例的共享成员。
            Customer.SetCompareKey(Customer.CompareField.Id)
        Else
            Customer.SetCompareKey(Customer.CompareField.Name)
        End If

        lstAfter.Items.Clear()
        lstArrayData.Items.Clear()
        lblDataAfter.Text = "No Data Displayed"
    End Sub

    Private Sub DataTypeCheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles optObjects.CheckedChanged, optValues.CheckedChanged
        ' 仅当在数组中加载对象时才启用
        ' grpCompareField。
        Dim opt As RadioButton = CType(sender, RadioButton)
        Me.grpCompareField.Enabled = Not (opt.Name = "optStrings")
        Me.lstArrayData.Items.Clear()
        Me.lstAfter.Items.Clear()
    End Sub

    Private Sub DisplayArrayData(ByVal arr As Array)
        ' 委托给下一个更复杂的版本。
        Me.DisplayArrayData(arr, WhichListBox.BoxOne)
    End Sub

    Private Sub DisplayArrayData(ByVal arr As Array, ByVal ListBox As WhichListBox)

        Dim i As Integer
        Dim u As Integer = (arr.Length - 1)

        Dim lst As ListBox
        If ListBox = WhichListBox.BoxOne Then
            lst = Me.lstArrayData
        Else
            lst = Me.lstAfter
        End If

        lst.Items.Clear()

        ' 计算传入数组具有多少个
        ' 维度（称为“秩”）。
        Select Case arr.Rank
            Case 1
                For i = 0 To u
                    lst.Items.Add(String.Format("{0} = {1}", i, arr.GetValue(i).ToString()))
                Next
            Case 2
                Dim j As Integer
                For i = 0 To (arr.GetLength(0) - 1)
                    For j = 0 To (arr.GetLength(1) - 1)
                        lst.Items.Add(String.Format("({0}, {1}) = {2}", i, j, arr.GetValue(i, j).ToString()))
                    Next j
                Next i

            Case Else
                ' 对不起，不能超过两个维度
                lst.Items.Add(String.Format("The array received has too many dimensions ({0})", arr.Rank))

        End Select
    End Sub

    Private Function MakeValueArray() As Integer()
        Dim numbers() As Integer = {3423, 9348, 3581, 7642, 2985}
        Return numbers
    End Function

    Private Function MakeObjectArray() As Customer()
        Dim numbers() As Integer = MakeValueArray()
        Dim names() As String = {"Jonas Hasselberg", "Gigi Mathew", "Amy Rusko", "Pedro Gutierrez", "Kok-Ho Loh"}
        Dim objData() As Customer = { _
            New Customer(numbers(0), names(0)), _
            New Customer(numbers(1), names(1)), _
            New Customer(numbers(2), names(2)), _
            New Customer(numbers(3), names(3)), _
            New Customer(numbers(4), names(4))}
        Return objData
    End Function


    ' 此代码将关闭窗体。
    Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        ' 关闭当前窗体
        Me.Close()
    End Sub
End Class
